#version 120

// Fragment shader for edge dection type effects
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;
uniform int mode;

uniform vec4 textureRect;
varying vec2 gUV;
uniform float randomValue;


#define theta_360 360.0f
#define theta_22_5 22.5f
#define theta_67_5 67.5f
#define theta_112_5 112.5f
#define theta_157_5 157.5f
#define theta_202_5 202.5f
#define theta_247_5 247.5f
#define theta_292_5 292.5f
#define theta_337_5 337.5f


float coeffs_fx[9] = float[](-1.0, 0.0, 1.0,-2.0, 0.0, 2.0,-1.0, 0.0, 1.0);

uniform float coeffs_fy[9] = float[9](+1.0f, +2.0f, +1.0f,
                                      +0.0f, +0.0f, +0.0f,
                                      -1.0f, -2.0f, -1.0f);

uniform vec2 offset[9] = vec2[9](vec2(-1.0f, +1.0f), vec2(+0.0f, +1.0f), vec2(+1.0f, +1.0f),
                                 vec2(-1.0f, +0.0f), vec2(+0.0f, +0.0f), vec2(+1.0f, +0.0f),
                                 vec2(-1.0f, -1.0f), vec2(+0.0f, -1.0f), vec2(+1.0f, -1.0f));

vec3 mod289(vec3 x) { return (x - floor(x * (1.0 / 289.0)) * 289.0); }
vec2 mod289(vec2 x)  { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }

float Snoise (vec2 v)
{
	const vec4 C = vec4(0.211324865405187,	// (3.0-sqrt(3.0))/6.0
						0.366025403784439,	// 0.5*(sqrt(3.0)-1.0)
						-0.577350269189626,	// -1.0 + 2.0 * C.x
						0.024390243902439);	// 1.0 / 41.0
    
	// First corner
	vec2 i  = floor(v + dot(v, C.yy) );
	vec2 x0 = v -   i + dot(i, C.xx);
    
	// Other corners
	vec2 i1;
	i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
	vec4 x12 = x0.xyxy + C.xxzz;
	x12.xy -= i1;
    
	// Permutations
	i = mod289(i); // Avoid truncation effects in permutation
	vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 ))
                     + i.x + vec3(0.0, i1.x, 1.0 ));
    
	vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
	m = m*m ;
	m = m*m ;
    
	// Gradients: 41 points uniformly over a line, mapped onto a diamond.
	// The ring size 17*17 = 289 is close to a multiple of 41 (41*7 = 287)
    
	vec3 x = 2.0 * fract(p * C.www) - 1.0;
	vec3 h = abs(x) - 0.5;
	vec3 ox = floor(x + 0.5);
	vec3 a0 = x - ox;
    
	// Normalise gradients implicitly by scaling m
	// Approximation of: m *= inversesqrt( a0*a0 + h*h );
	m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );
    
	// Compute final noise value at P
	vec3 g;
	g.x  = a0.x  * x0.x  + h.x  * x0.y;
	g.yz = a0.yz * x12.xz + h.yz * x12.yw;
	return 130.0 * dot(m, g);
}  


void main(void)
{
	if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        vec2 pos;
        float theta;
        float y = 0.0f, gx = 0.0f, gy = 0.0f;
        vec2 current = vec2(gUV.x, gUV.y);
        for (int i = 0; i < offset.length(); i++)
        {
            pos.x = current.x+offset[i].x;
            pos.y = current.y+offset[i].y;
            y = texture2DRect(texUnit, pos).r;
            gx += (y*coeffs_fx[i]);
            gy += (y*coeffs_fy[i]);
        }
        y = sqrt((gx*gx)+(gy*gy));

    //    theta = degrees(atan(abs(gy), abs(gx)));
    //    if (gx >= 0.0f && gy >= 0.0f)
    //        theta += 0.0f;
    //    else if (gx < 0.0f && gy >= 0.0f)
    //        theta = 180.0f-theta;
    //    else if (gx < 0.0f && gy < 0.0f)
    //        theta = 180.0f+theta;
    //    else
    //        theta = 360.0f-theta;
    //    if ((theta >= theta_22_5 && theta < theta_67_5)||(theta >= theta_202_5 && theta < theta_247_5))
    //        theta = 0.25f;
    //    else if ((theta >= theta_67_5 && theta < theta_112_5)||(theta >= theta_247_5 && theta < theta_292_5))
    //        theta = 0.5f;
    //    else if ((theta >= theta_112_5 && theta < theta_157_5)||(theta >= theta_292_5 && theta < theta_337_5))
    //        theta = 0.75f;
    //    else
    //        theta = 0.0f;
        
        vec4 outColor;
        if(mode==0)
        {
            outColor=texture2DRect(texUnit,gUV)*vec4(.3,.3,.3,1.);
            outColor.r+=y*Snoise(vec2(1024. + randomValue * 512.0, 1024.0 + randomValue * 512.0)) * 1.0;
            outColor.r=min(255.,outColor.r);
            outColor.g+=y*Snoise(vec2(1024. - randomValue * 512.0, 1024.0 - randomValue * 512.0)) * 1.0;
            outColor.g=min(255.,outColor.g);
            outColor.b+=y*Snoise(vec2(1024. + randomValue * 512.0, 1024.0 - randomValue * 512.0)) * 1.0;
            outColor.b=min(255.,outColor.b);
        }
        else if(mode==1)
        {
            outColor=texture2DRect(texUnit,gUV)*vec4(.3,.3,.3,1.);
    //        outColor=vec4(texture2DRect(texUnit,gUV).g);
            outColor.r+=y;
            outColor.r=min(255.,outColor.r);
            outColor.g+=y;
            outColor.g=min(255.,outColor.g);
            outColor.b+=y;
            outColor.b=min(255.,outColor.b);
            
        }
        else
        {
            outColor=texture2DRect(texUnit,gUV)*vec4(.8063,.863,.863,1.);
            float noise=Snoise(gUV*vec2(1024. + randomValue * 512.0, 1024.0 + randomValue * 512.0)) * 1.0;
            y*=noise;
            outColor.r+=y;
            outColor.r=min(255.,outColor.r);
            outColor.g+=y;
            outColor.g=min(255.,outColor.g);
            outColor.b+=y;
            outColor.b=min(255.,outColor.b);
        }

        gl_FragColor = outColor;
        gl_FragColor.a = texture2DRect(texUnit, gUV).a;    
    }
}


float dX=2.5;
float dY=2.5;

vec4 sample(float dx,float dy)
{
    return texture2DRect(texUnit,gUV+vec2(dx,dy));
}

void main5()
{
    vec4 color = sample(0.0,0.0);
//    dX=randomValue;
//    dY=randomValue;
    color = max(color , sample(-dX,+dY));
    color = max(color , sample(0.0,+dY));
    color = max(color , sample(+dX,+dY));
    color = max(color , sample(-dX,0.0));
    color = max(color , sample(+dX,0.0));
    color = max(color , sample(-dX,-dY));
    color = max(color , sample(0.0,-dY));
    color = max(color , sample(+dX,-dY));
    gl_FragColor = color;
}


void main9 (void) {
    vec2 uv = gUV;
    vec4 c = texture2DRect(texUnit, uv);
    float scale=512.+Snoise(vec2(1024. + randomValue * 512.0, 1024.0 + randomValue * 512.0))*128.;
    
    c += texture2DRect(texUnit, uv+0.001*scale);
    c += texture2DRect(texUnit, uv+0.003*scale);
    c += texture2DRect(texUnit, uv+0.005*scale);
    c += texture2DRect(texUnit, uv+0.007*scale);
    c += texture2DRect(texUnit, uv+0.009*scale);
    c += texture2DRect(texUnit, uv+0.011*scale);
    
    c += texture2DRect(texUnit, uv-0.001*scale);
    c += texture2DRect(texUnit, uv-0.003*scale);
    c += texture2DRect(texUnit, uv-0.005*scale);
    c += texture2DRect(texUnit, uv-0.007*scale);
    c += texture2DRect(texUnit, uv-0.009*scale);
    c += texture2DRect(texUnit, uv-0.011*scale);
    
//    c.rgb = vec3((c.r+c.g+c.b)/3.0);
    c = c / 9.5;
    gl_FragColor = c;
    
}



#define HueLevCount 6
#define SatLevCount 7
#define ValLevCount 4
float HueLevels[HueLevCount];// = float[] (0.0,80.0,160.0,240.0,320.0,360.0);
float SatLevels[SatLevCount];// = float[] (0.0,0.15,0.3,0.45,0.6,0.8,1.0);
float ValLevels[ValLevCount];// = float[] (0.0,0.3,0.6,1.0);

vec3 RGBtoHSV2( float r, float g, float b) {
    float minv, maxv, delta;
    vec3 res;
    
    minv = min(min(r, g), b);
    maxv = max(max(r, g), b);
    res.z = maxv;            // v
    
    delta = maxv - minv;
    
    if( maxv != 0.0 )
        res.y = delta / maxv;      // s
    else {
        // r = g = b = 0      // s = 0, v is undefined
        res.y = 0.0;
        res.x = -1.0;
        return res;
    }
    
    if( r == maxv )
        res.x = ( g - b ) / delta;      // between yellow & magenta
    else if( g == maxv )
        res.x = 2.0 + ( b - r ) / delta;   // between cyan & yellow
    else
        res.x = 4.0 + ( r - g ) / delta;   // between magenta & cyan
    
    res.x = res.x * 60.0;            // degrees
    if( res.x < 0.0 )
        res.x = res.x + 360.0;
    
    return res;
}

vec3 RGBtoHSV(float r, float g, float b) {
    
    float K = 0.0;
    float tmp;
    
    if (g < b)
    {
        tmp = g;
        g=b;
        b=tmp;
        
        K = -1.0;
    }
    
    if (r < g)
    {
        tmp = r;
        r=g;
        g=tmp;
        
        K = -2.9 / 6.9 - K;
    }
    
    float chroma = r - min(g, b);
    
    float h = abs(K + (g - b) / (6.0 * chroma + 1e-20));
    float s = chroma / (r + 1e-20);
    float v = r;
    
    return vec3(h, s, v);
}

vec3 HSVtoRGB2(float h, float s, float v ) {
    int i;
    float f, p, q, t;
    vec3 res;
    
    if( s == 0.0 ) {
        // achromatic (grey)
        res.x = v;
        res.y = v;
        res.z = v;
        return res;
    }
    
    h /= 60.0;         // sector 0 to 5
    i = int(floor( h ));
    f = h - float(i);         // factorial part of h
    p = v * ( 1.0 - s );
    q = v * ( 1.0 - s * f );
    t = v * ( 1.0 - s * ( 1.0 - f ) );
    
    if (i == 0) {
        res.x = v;
        res.y = t;
        res.z = p;
    } else if (i == 1) {
        res.x = q;
        res.y = v;
        res.z = p;
    } else if (i == 2) {
        res.x = p;
        res.y = v;
        res.z = t;
    } else if (i == 3) {
        res.x = p;
        res.y = q;
        res.z = v;
    } else if (i == 4) {
        res.x = t;
        res.y = p;
        res.z = v;
    } else if (i == 5) {
        res.x = v;
        res.y = p;
        res.z = q;
    }
    
    return res;
}

vec3 HSVtoRGB3(float h, float s, float v)
{
    if (s <= 0 ) { return vec3 (v); }
    h = h * 6;
    float c = v*s;
    float x = (1-abs((mod(h,2)-1)))*c;
    float m = v-c;
    float r = 0.0;
    float g = 0.0;
    float b = 0.0;
    
    if (h < 1) { r = c; g = x;b = 0.0;}
    else if (h < 2) { r = x; g = c; b = 0.0; }
    else if (h < 3) { r = 0.0; g = c; b = x; }
    else if (h < 4) { r = 0.0; g = x; b = c; }
    else if (h < 5) { r = x; g = 0.0; b = c; }
    else  { r = c; g = 0.0; b = x; }
    
    return vec3(r+m,g+m,b+m);
}

vec3 HSVtoRGB(float h,float s,float v) { return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v; }

float nearestLevel(float col, int mode) {
    
    int levCount;
    if (mode==0) levCount = HueLevCount;
    if (mode==1) levCount = SatLevCount;
    if (mode==2) levCount = ValLevCount;
    
    for (int i =0; i<levCount-1; i++ )
    {
        if (mode==0)
        {
            if (col >= HueLevels[i] && col <= HueLevels[i+1])
            {
                return HueLevels[i+1];
            }
        }
        if (mode==1)
        {
            if (col >= SatLevels[i] && col <= SatLevels[i+1])
            {
                return SatLevels[i+1];
            }
        }
        if (mode==2)
        {
            if (col >= ValLevels[i] && col <= ValLevels[i+1])
            {
                return ValLevels[i+1];
            }
        }
    }
}

// averaged pixel intensity from 3 color channels
float avg_intensity(vec4 pix) {
    return (pix.r + pix.g + pix.b)/3.;
}

vec4 get_pixel(vec2 coords, float dx, float dy) {
    return texture2DRect(texUnit,coords + vec2(dx, dy));
}

// returns pixel color
float IsEdge2(in vec2 coords){
    float dxtex = 1.0;
    float dytex = 1.0;
    float pix[9];
    int k = -1;
    float delta;
    
    // read neighboring pixel intensities
    for (int i=-1; i<2; i++) {
        for(int j=-1; j<2; j++) {
            k++;
            pix[k] = avg_intensity(get_pixel(coords,float(i)*dxtex,
                                             float(j)*dytex));
        }
    }
    
    // average color differences around neighboring pixels
    delta = (abs(pix[1]-pix[7])+
             abs(pix[5]-pix[3]) +
             abs(pix[0]-pix[8])+
             abs(pix[2]-pix[6])
             )/4.;
    
    return clamp(5.5*delta,0.0,1.0);
}

float IsEdge(in vec2 coords)
{
    vec2 pos;
    float theta;
    float y = 0.0f, gx = 0.0f, gy = 0.0f;
    vec2 current = coords;
    for (int i = 0; i < offset.length(); i++)
    {
        pos.x = current.x+offset[i].x;
        pos.y = current.y+offset[i].y;
        y = texture2DRect(texUnit, pos).r;
        gx += (y*coeffs_fx[i]);
        gy += (y*coeffs_fy[i]);
    }
	y = sqrt((gx*gx)+(gy*gy));
    return(y);
}

void main8(void)
{
	HueLevels[0] = 0.0;
	HueLevels[1] = 80.0/360.;
	HueLevels[2] = 160.0/360.;
	HueLevels[3] = 240.0/360.;
	HueLevels[4] = 320.0/360.;
	HueLevels[5] = 360.0/360.;
    
	SatLevels[0] = 0.0;
	SatLevels[1] = 0.15;
	SatLevels[2] = 0.30;
	SatLevels[3] = 0.45;
	SatLevels[4] = 0.60;
	SatLevels[5] = 0.80;
	SatLevels[6] = 1.0;
    
	ValLevels[0] = 0.0;
	ValLevels[1] = 0.3;
	ValLevels[2] = 0.6;
	ValLevels[3] = 1.0;
    
    vec4 color = sample(0.0,0.0);
    //    dX=randomValue;
    //    dY=randomValue;
    color += sample(-dX,+dY);
    color += sample(0.0,+dY);
    color += sample(+dX,+dY);
    color += sample(-dX,0.0);
    color += sample(+dX,0.0);
    color += sample(-dX,-dY);
    color += sample(0.0,-dY);
    color += sample(+dX,-dY);
    color/=9.;
    
    vec3 vHSV =  RGBtoHSV(color.r,color.g,color.b);
    vHSV.x = nearestLevel(vHSV.x, 0);
    vHSV.y = nearestLevel(vHSV.y, 1);
    vHSV.z = nearestLevel(vHSV.z, 2);
    float edg = IsEdge(gUV);
    vec3 vRGB = (edg >= 0.33)? vec3(0.0,0.0,0.0):HSVtoRGB(vHSV.x,vHSV.y,vHSV.z);
//    vec3 vRGB = (1.0-edg)*HSVtoRGB(vHSV.x,vHSV.y,vHSV.z);
    gl_FragColor = vec4(min(1.0,vRGB.x),min(1.0,vRGB.y),min(1.0,vRGB.z),1.0);
}

uniform float Opacity=1.01;

void main7()
{
	vec4 base = texture2DRect(texUnit, gUV);
    vec3 lumCoeff = vec3(0.25,0.65,0.1);
	float lum = dot(lumCoeff,base.rgb);
    
	vec3 blend = vec3(lum,lum,lum);
    float L = min(1,max(0,10*(lum- 0.45)));
    vec3 result1 = 2.0f * base.rgb * blend;
    vec3 result2 = 1.0f - 2.0f*(1.0f-blend)*(1.0f-base.rgb);
	vec3 newColor = mix(result1,result2,L);
    float A2 = Opacity;// * base.a;
    vec3 mixRGB = A2 * newColor.rgb;
    mixRGB += ((1.0f-A2) * base.rgb);
	gl_FragColor=vec4(mixRGB,base.a);
}



//        vec4 texel = texture2DRect(texUnit, gUV);
//        vec2 redLoc=gUV;
//        redLoc.x-=20.;
//        vec2 greenLoc=gUV;
//        greenLoc.x+=20.;
//        greenLoc.y+=20.;
//        vec2 blueLoc=gUV;
//        blueLoc.x-=10.;
//        blueLoc.y-=10.;
//        vec4 red=texture2DRect(texUnit,redLoc)*vec4(1.0,0.0,0.0,1.0);
//        vec4 green=texture2DRect(texUnit,greenLoc)*vec4(0.0,1.0,0.0,1.0);
//        vec4 blue=texture2DRect(texUnit,blueLoc)*vec4(0.0,0.0,1.0,1.0);
//
//        gl_FragColor = red+blue+green;

// white fade transition
//        if(inAlphaValue<.5)
//            blendColor=mix(outTexColor,vec4(1.0,1.0,1.0,1.0),inAlphaValue*2.);
//        else
//            blendColor=mix(vec4(1.0,1.0,1.0,1.0),inTexColor,(inAlphaValue-.5)*2.);
